<?php

/**
 * Advanced Security - PHP Register/Login System
 *
 * @author Milos Stojanovic
 * @link   http://mstojanovic.net
 */

class ASHr
{
   
    /**
     * @var ASDatabase Instance of ASDatabase class
     */
    private $db = null;

    /**
     * @var ASValidator Instance of ASValidator class
     */
    private $validator;

    /**
     * Class constructor
     * @param ASDatabase $db
     * @param ASValidator $validator
     */
    public function __construct(ASDatabase $db, ASValidator $validator)
    {
        $this->db = $db;
        $this->validator = $validator;
    }

    /**
     * Get role id of role that have provided role name.
     *
     * @param $name string Role name
     * @return int Role id if role with provided role name exist, null otherwise.
     */
    public function getId(string $name): ?int
    {
        $result = $this->db->select(
            "SELECT `role_id` FROM `as_user_roles` WHERE `role` = :r",
            ['r' => $name]
        );

        return $result !== []
            ? (int) $result[0]['role_id']
            : null;
    }

    /**
     * Get role name of role with provided id.
     *
     * @param $id int Role id
     * @return string Role Name if role with provided role id exist, null otherwise.
     */
    public function name(int $id): ?string
    {
        $result = $this->db->select(
            "SELECT `role` FROM `as_user_roles` WHERE `role_id` = :id",
            ['id' => $id]
        );

        return $result !== []
            ? $result[0]['role']
            : null;
    }

    

    public function adaugaDepartamente($denumire,$descriere,$id_user): void
    {
      

        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);

        $this->db->insert("as_hr_departamente", 
            [
                "denumire" => $denumire,
                "descriere" => $descriere,
                "id_user"=>$id_user

            ]
        );

        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    public function modificaDepartamente($id,$denumire,$descriere): void
    {
      
        $id=$id;
        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);

        $this->db->update(
            "as_hr_departamente",
            [
                "denumire" => $denumire,
                "descriere" => $descriere
            ],
            "`id` = :id",
            ["id" => $id]
        );


        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    /**
     * Delete role with provided id.
     *
     * @param $id int Role id
     */
    public function stergeDepartamente(int $id): void
    {
       
        $this->db->delete("as_hr_departamente", "id = :id", ["id" => $id]);


        ASResponse::success();
    }
    
    
    
    
    public function adaugaPosturi($denumire,$descriere,$id_departament,$id_user): void
    {
      

        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);

        $this->db->insert("as_hr_posturi", 
            [
                "id_departament"=>$id_departament,
                "denumire" => $denumire,
                "descriere" => $descriere,
                "id_user"=>$id_user

            ]
        );

        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    public function modificaPosturi($id,$denumire,$descriere,$id_departament): void
    {
      
        $id=$id;
        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);

        $this->db->update(
            "as_hr_posturi",
            [
                "id_departament"=>$id_departament,
                "denumire" => $denumire,
                "descriere" => $descriere
            ],
            "`id` = :id",
            ["id" => $id]
        );


        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    /**
     * Delete role with provided id.
     *
     * @param $id int Role id
     */
    public function stergePosturi(int $id): void
    {
       
        $this->db->delete("as_hr_posturi", "id = :id", ["id" => $id]);


        ASResponse::success();
    }




}
