<?php

/**
 * Advanced Security - PHP Register/Login System
 *
 * @author Milos Stojanovic
 * @link   http://mstojanovic.net
 */

class ASAdministrare
{
   
    /**
     * @var ASDatabase Instance of ASDatabase class
     */
    private $db = null;

    /**
     * @var ASValidator Instance of ASValidator class
     */
    private $validator;

    /**
     * Class constructor
     * @param ASDatabase $db
     * @param ASValidator $validator
     */
    public function __construct(ASDatabase $db, ASValidator $validator)
    {
        $this->db = $db;
        $this->validator = $validator;
    }

    /**
     * Get role id of role that have provided role name.
     *
     * @param $name string Role name
     * @return int Role id if role with provided role name exist, null otherwise.
     */
    public function getId(string $name): ?int
    {
        $result = $this->db->select(
            "SELECT `role_id` FROM `as_user_roles` WHERE `role` = :r",
            ['r' => $name]
        );

        return $result !== []
            ? (int) $result[0]['role_id']
            : null;
    }

   public function getOrase($id_tara)
    {
        $result = $this->db->select(
            "SELECT * FROM `as_orase` WHERE `id_tara` = :r",
            ['r' => $id_tara]
        );

        return $result;
    }
    
    public function getPhone($id,$data)
    {
        $result = $this->db->select(
            "SELECT * FROM `as_soferi` WHERE `uid` = '".$id."'",
            []
        );
        
        $result_tp = $this->db->select(
            "SELECT * FROM `as_tari` WHERE `id` = ".$data["id_tara_plecare"]." ",
            []
        );
        
        $result_op = $this->db->select(
            "SELECT * FROM `as_orase` WHERE `id` = ".$data["id_oras_plecare"]." ",
            []
        );
        
        
        $result_td = $this->db->select(
            "SELECT * FROM `as_tari` WHERE `id` = ".$data["id_tara_destinatie"]." ",
            []
        );
        
        $result_od = $this->db->select(
            "SELECT * FROM `as_orase` WHERE `id` = ".$data["id_oras_destinatie"]." ",
            []
        );
        
        $this->db->insert("as_istoric_soferi", 
            [
                "id_sofer" => $result[0]["id"],
                "id_tara_plecare" => $data["id_tara_plecare"],
                "id_oras_plecare" => $data["id_oras_plecare"],
                "id_tara_destinatie" => $data["id_tara_destinatie"],
                "id_oras_destinatie" => $data["id_oras_destinatie"],
                "telefon_client" => $data["telefon"]

            ]
        );
        
        $msg_wha="Un utilizator a dat click pe numarul tau de telefon:

📲 Telefon: ".$data["telefon"]." 
📍Preluare: ".$result_tp[0]["denumire"]."  - ".$result_op[0]["denumire"]."
🏁 Destinatie: ".$result_td[0]["denumire"]."  - ".$result_od[0]["denumire"]."
                
Cu drag, TRANSPO.RO";
            $url = "http://sms.start-soft.ro/api/send/whatsapp";
            $data = [
                "secret" => "754cc1a8632c730219f278974b8840d795c99432",
                "account" => "1738315497c4ca4238a0b923820dcc509a6f75849b679c96e9dc981",
                "recipient" => $result[0]['telefon'],
                 "type" => "text",
                "message" => $msg_wha
            ];
            
            // Initialize cURL session
            $ch = curl_init();
            
            // Set cURL options
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            
            // Execute the request
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        return $result;
    }



    public function adaugaAlteServicii($denumire,$descriere): void
    {
        if ($this->validator->categorieEvenimenteExist($denumire)) {
            ASResponse::validationError(["error" => "Aceasta denumire exista!"]);
        }

        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);
        $id_categorie=$id_categorie;

        $this->db->insert("as_alte_servicii", 
            [
                "denumire" => $denumire,
                "descriere" => $descriere

            ]
        );

        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    public function updateTariOrase($idSofer,$idTari,$idOrase): void
    {
      
       

        $this->db->update(
            "as_soferi",
            [
                "id_tari" => substr($idTari, 0, -1),
                "id_orase" => substr($idOrase, 0, -1)
            ],
            "`id` = :id",
            ["id" => $idSofer]
        );


        ASResponse::success([
           
            "id" => $idTari
        ]);
    }
    
     public function updateCont($data): void
    {
      
       

        $this->db->update(
            "as_soferi",
            [
                "nume" => $data["nume"],
                "imagine" => $data["fisier"]
            ],
            "`id` = :id",
            ["id" => $data["id_sofer"]]
        );


        ASResponse::success([
           
            "id" => $idTari
        ]);
    }
    
    public function modificaAlteServicii($id,$denumire,$descriere): void
    {
      
        $id=$id;
        $denumire = strip_tags($denumire);
        $descriere = strip_tags($descriere);

        $this->db->update(
            "as_alte_servicii",
            [
                "denumire" => $denumire,
                "descriere" => $descriere
            ],
            "`id` = :id",
            ["id" => $id]
        );


        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

    /**
     * Delete role with provided id.
     *
     * @param $id int Role id
     */
    public function stergeAlteServicii(int $id): void
    {
       
        $this->db->delete("as_alte_servicii", "id = :id", ["id" => $id]);


        ASResponse::success();
    }



    public function adaugaCerere($nume,$telefon,$email,$adresa,$material,$data): void
    {
        
        $nume = strip_tags($nume);
        $telefon = strip_tags($telefon);
        $email = strip_tags($email);
        $adresa = strip_tags($adresa);
        $material = strip_tags($material);
        $data = strip_tags($data);

        $this->db->insert("as_cereri", 
            [
                "nume" => $nume,
                "telefon" => $telefon,
                "email" => $email,
                "adresa" => $adresa,
                "id_material" => $material,
                "data" => $data,
                "cod_stripe"=>rand(124824833,87483123)

            ]
        );

        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

   
   public function adaugaCerereDimensiune($id,$dimensiune): void
    {
        $dimensiune = strip_tags($dimensiune);

        $this->db->update(
            "as_cereri",
            [
                "dimensiune_unu" => $dimensiune
            ],
            "`id` = :id",
            ["id" => $id]
        );
        
        ASResponse::success([
            "denumire" => $denumire,
            "id" => $this->db->lastInsertId()
        ]);
    }

}
